class Proj_Tower_Krall extends Projectile;

var Pawn Tower;
var Pawn instigator;

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}

function PostBeginPlay()
{
	Speed = 250;
	Velocity = Vector(Rotation) * speed;
	PlaySound(SpawnSound,SLOT_None,4.0);
	Super.PostBeginPlay();
} 

function MakeSound()
{
	PlaySound(ImpactSound, SLOT_Interact);
	MakeNoise(1.0);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	local SmokeColumn s;

	MakeSound();
 	s = spawn(class'SmokeColumn',,,Location+Vect(0,0,38));
	s.RemoteRole = ROLE_None;
	destroy();
}
	

auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
	local vector momentum;
	local UT_SpriteBallChild S;
	
	if ( Other.IsA('Balloon') )
		{
		if ( Role == ROLE_Authority )
			{
			momentum = MomentumTransfer * Normal(Velocity);
			if ( PBPRI(PlayerPawn(instigator).PlayerReplicationInfo).KrallLevel > 1 )
				{
				Other.TakeDamage( 15, instigator, HitLocation, momentum, 'Tower');
				S = spawn(class'UT_SpriteBallChild',,,Self.Location);
				S.PlaySound(Sound'UnrealShare.General.Explo1',,12.0,,2200);
				S.DrawScale = 0.500000;
				S.RemoteRole = ROLE_None;
				//Assign damage count to tower:
				if ( Balloon(Other).Health >= 15 )
					TowerPRI(Tower.PlayerReplicationInfo).DamageDone += 15;
				else
					TowerPRI(Tower.PlayerReplicationInfo).DamageDone += Balloon(Other).Health;
				}
			else
				{
				Other.TakeDamage( 5, instigator, HitLocation, momentum, 'Tower');
				//Assign damage count to tower:
				if ( Balloon(Other).Health >= 5 )
					TowerPRI(Tower.PlayerReplicationInfo).DamageDone += 5;
				else
					TowerPRI(Tower.PlayerReplicationInfo).DamageDone += Balloon(Other).Health;
				}
			}
		Destroy();
		}
	}

Begin:
	Sleep(7.0); //self destruct after 7.0 seconds
	Explode(Location, vect(0,0,0));
}

defaultproperties
{
     speed=1600.000000
     MaxSpeed=1600.000000
     Damage=5.000000
     MomentumTransfer=10000
     SpawnSound=Sound'UnrealI.Krall.Krasht2'
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=7.500000
     Mesh=LodMesh'UnrealI.Krallbm'
     AmbientGlow=255
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=102
     LightRadius=4
}
